﻿// Copyright 2020-2023 MesionTech Technology Co., Ltd. All Rights Reserved.

#include "YyssXREditor.h"
#include "YyssXRSettingsCustomization.h"

#include "ISettingsModule.h"

static const FName YyssXREditorTabName("YyssXREditor");

#define LOCTEXT_NAMESPACE "FYyssXREditorModule"

void FYyssXREditorModule::StartupModule()
{
	RegisterSettings();
}

void FYyssXREditorModule::ShutdownModule()
{

}

void FYyssXREditorModule::RegisterSettings()
{

	FPropertyEditorModule& PropertyModule = FModuleManager::LoadModuleChecked<FPropertyEditorModule>("PropertyEditor");
	PropertyModule.RegisterCustomClassLayout(
		UYyssXRHMDSettings::StaticClass()->GetFName(),
		FOnGetDetailCustomizationInstance::CreateStatic(&FYyssXRSettingsCustomization::MakeInstance)
	);
	PropertyModule.NotifyCustomizationModuleChanged();

	ISettingsModule* SettingsModule = FModuleManager::GetModulePtr<ISettingsModule>("Settings");

	if (SettingsModule != nullptr)
	{
		SettingsModule->RegisterSettings("Project", "Plugins", "YyssXR",
			LOCTEXT("YyssXRSettingsName", "Yyss XR"),
			LOCTEXT("YyssXRSettingsDescription", "Configure the YyssXR plug-in."),
			GetMutableDefault<UYyssXRHMDSettings>()
		);
	}
}

void FYyssXREditorModule::UnregisterSettings()
{
	ISettingsModule* SettingsModule = FModuleManager::GetModulePtr<ISettingsModule>("Settings");
	if (SettingsModule != nullptr)
	{
		SettingsModule->UnregisterSettings("Project", "Plugins", "YyssXR");
	}
}

IMPLEMENT_MODULE(FYyssXREditorModule, YyssXREditor)

#undef LOCTEXT_NAMESPACE