﻿// Copyright 2020-2023 MesionTech Technology Co., Ltd. All Rights Reserved.

#include "YyssXRSettingsCustomization.h"
#if WITH_EDITOR
#include "ISettingsModule.h"
#include "PropertyHandle.h"
#include "DetailLayoutBuilder.h"
#include "DetailCategoryBuilder.h"
#include "Modules/ModuleManager.h"

#define LOCTEXT_NAMESPACE "YyssRuntimeSettings"

FYyssXRSettingsCustomization::FYyssXRSettingsCustomization()
    :SavedLayoutBuilder(nullptr)
{
    YyssSettings = GetMutableDefault<UYyssXRHMDSettings>();
}

TSharedRef<IDetailCustomization> FYyssXRSettingsCustomization::MakeInstance()
{
    return MakeShareable(new FYyssXRSettingsCustomization);
}

void FYyssXRSettingsCustomization::CustomizeDetails(IDetailLayoutBuilder& DetailLayout)
{
    SavedLayoutBuilder = &DetailLayout;
    DetailLayout.EditCategory(TEXT("YyssMobile"));
}
#endif