// Copyright 2020-2023 Mesiontech Technology Co., Ltd. All Rights Reserved.

#include "YyssXRFunctionLibrary.h"
#include "YyssXRHMD.h"

UYyssXRFunctionLibrary::UYyssXRFunctionLibrary(const FObjectInitializer& ObjectInitializer)
	: Super(ObjectInitializer)
{
}

FYyssXRHMD* UYyssXRFunctionLibrary::GetYyssHMD()
{
	if (GEngine && GEngine->XRSystem.IsValid())
	{
		if (GEngine->XRSystem->GetSystemName() == FName("YyssXR"))//todo
		{
			return static_cast<FYyssXRHMD*>(GEngine->XRSystem.Get());
		}
	}
	return nullptr;
}

void UYyssXRFunctionLibrary::GetPose(FRotator& DeviceRotation, FVector& DevicePosition, FVector& NeckPosition, bool bUseOrienationForPlayerCamera, bool bUsePositionForPlayerCamera, const FVector PositionScale)
{
	FYyssXRHMD* YyssHMD = GetYyssHMD();
	if (YyssHMD != nullptr)
	{
		FQuat HeadOrientation = FQuat::Identity;
		FVector HeadPosition = FVector::ZeroVector;

		YyssHMD->GetCurrentPose(YyssHMD->HMDDeviceId, HeadOrientation, HeadPosition);

		DeviceRotation = HeadOrientation.Rotator();
		DevicePosition = HeadPosition;
		NeckPosition = FVector::ZeroVector;
	}
	else
	{
		DeviceRotation = FRotator::ZeroRotator;
		DevicePosition = FVector::ZeroVector;
		NeckPosition = FVector::ZeroVector;
	}
}

// void UYyssXRFunctionLibrary::SetCPUAndGPULevels(int CPULevel, int GPULevel)
// {
// 	FYyssXRHMD* YyssHMD = GetYyssHMD();
// 	if (YyssHMD != nullptr)
// 	{
// 		YyssHMD->SetCpuLevel((uint8)CPULevel);
// 		YyssHMD->SetGpuLevel((uint8)GPULevel);
// 	}
// }

bool UYyssXRFunctionLibrary::HasInputFocus()
{
	FYyssXRHMD* YyssHMD = GetYyssHMD();
	if (YyssHMD != nullptr)
	{
		return YyssHMD->IsFocused();
	}
	return false;
}

bool UYyssXRFunctionLibrary::HasSystemOverlayPresent()
{
	FYyssXRHMD* YyssHMD = GetYyssHMD();
	if (YyssHMD != nullptr)
	{
		return !YyssHMD->IsFocused();
	}
	return false;
}

// EYyssFixedFoveatedRenderingLevel UYyssXRFunctionLibrary::GetFixedFoveatedRenderingLevel()
// {
// 	FYyssXRHMD* YyssHMD = GetYyssHMD();
// 	if (YyssHMD != nullptr)
// 	{
// 		return (EYyssFixedFoveatedRenderingLevel)YyssHMD->GetFFRLevel();
// 	}
// 	return EYyssFixedFoveatedRenderingLevel::FFR_OFF;
// }

// void UYyssXRFunctionLibrary::SetFixedFoveatedRenderingLevel(EYyssFixedFoveatedRenderingLevel level)
// {
// 	FYyssXRHMD* YyssHMD = GetYyssHMD();
// 	if (YyssHMD != nullptr)
// 	{
// 		YyssHMD->SetFFRLevel((uint8)level);
// 	}
// }

TArray<float> UYyssXRFunctionLibrary::GetAvailableDisplayFrequencies()
{
	return TArray<float>({ 72.0f, 90.0f });
}

// float UYyssXRFunctionLibrary::GetCurrentDisplayFrequency()
// {
// 	FYyssXRHMD* YyssHMD = GetYyssHMD();
// 	if (YyssHMD != nullptr)
// 	{
// 		return YyssHMD->GetDisplayRefreshRate();
// 	}
// 	return 0.0f;
// }

// void UYyssXRFunctionLibrary::SetDisplayFrequency(float RequestedFrequency)
// {
// 	FYyssXRHMD* YyssHMD = GetYyssHMD();
// 	if (YyssHMD != nullptr)
// 	{
// 		YyssHMD->SetDisplayRefreshRate(RequestedFrequency);
// 	}
// }

// void UYyssXRFunctionLibrary::SetColorScaleAndOffset(FLinearColor ColorScale, FLinearColor ColorOffset, bool bApplyToAllLayers)
// {
// 	FYyssXRHMD* YyssHMD = GetYyssHMD();
// 	if (YyssHMD != nullptr)
// 	{
// 		YyssHMD->SetColorScaleAndOffset(ColorScale, ColorOffset, bApplyToAllLayers);
// 	}
// }