// Copyright 2020-2023 Mesiontech Technology Co., Ltd. All Rights Reserved.

#include "YyssXRHMDSettings.h"
#include "Engine/RendererSettings.h"

UYyssXRHMDSettings::UYyssXRHMDSettings(const FObjectInitializer& ObjectInitializer)
	: Super(ObjectInitializer)
	, CPULevel(EPerformanceLevel::LEVEL_BOOST)
	, GPULevel(EPerformanceLevel::LEVEL_BOOST)
	, PixelDensity(1.0f)
	, DisplayRefreshRate(90.0f)
	, bApplyColorScaleAndOffsetToAllLayers(false)
	, ColorScale(FLinearColor(1.0f, 1.0f, 1.0f, 1.0f))
	, ColorOffset(FLinearColor(0.0f, 0.0f, 0.0f, 0.0f))
	, bUseHWsRGBEncoding(false)
{
#if WITH_EDITOR
	ResetsRGBConfig();
#endif
}

void UYyssXRHMDSettings::PostInitProperties()
{
	Super::PostInitProperties();
}

#if WITH_EDITOR
void UYyssXRHMDSettings::PostEditChangeProperty(FPropertyChangedEvent& PropertyChangedEvent)
{
	Super::PostEditChangeProperty(PropertyChangedEvent);
	Super::UpdateDefaultConfigFile();
	HandlesRGBHWSupport();
}

void UYyssXRHMDSettings::HandlesRGBHWSupport()
{
	URendererSettings* const Settings = GetMutableDefault<URendererSettings>();
	static auto* MobileUseHWsRGBEncodingCVAR = IConsoleManager::Get().FindConsoleVariable(TEXT("r.Mobile.UseHWsRGBEncoding"));

	if (bUseHWsRGBEncoding != Settings->bMobileUseHWsRGBEncoding)
	{
		Settings->bMobileUseHWsRGBEncoding = bUseHWsRGBEncoding;
		Settings->UpdateSinglePropertyInConfigFile(Settings->GetClass()->FindPropertyByName(GET_MEMBER_NAME_CHECKED(URendererSettings, bMobileUseHWsRGBEncoding)), GetDefaultConfigFilename());
	}

	if (MobileUseHWsRGBEncodingCVAR && MobileUseHWsRGBEncodingCVAR->GetInt() != (int)bUseHWsRGBEncoding)
	{
		MobileUseHWsRGBEncodingCVAR->Set((int)bUseHWsRGBEncoding);
	}
}

void UYyssXRHMDSettings::ResetsRGBConfig()
{
	// To Prevent sRGB from being turned off by AndroidSetting
	FEditorDelegates::RefreshAllBrowsers.AddUObject(this, &UYyssXRHMDSettings::HandlesRGBHWSupport);
}

#endif