// Copyright 2020-2023 Mesiontech Technology Co., Ltd. All Rights Reserved.

#pragma once
#include "CoreMinimal.h"
#include "UObject/Object.h"
#include "YyssXRFunctionLibrary.h"
#include "YyssXRHMDSettings.generated.h"

/**
* Implements the settings for the YyssVR plugin.
*/
UCLASS(config = Engine, defaultconfig)
class YYSSXRHMD_API UYyssXRHMDSettings : public UObject
{
	GENERATED_UCLASS_BODY()

public:

	/** Default CPU level controlling CPU frequency on the mobile device */
	UPROPERTY(config, EditAnywhere, Category = General)
		EPerformanceLevel CPULevel;

	/** Default GPU level controlling GPU frequency on the mobile device */
	UPROPERTY(config, EditAnywhere, Category = General)
		EPerformanceLevel GPULevel;

	/** Default Fixed Foveated Rendering level for Yyss device*/
	// UPROPERTY(config, EditAnywhere, Category = General)
	// 	EYyssFixedFoveatedRenderingLevel FFRLevel;

	UPROPERTY(Config, EditAnywhere, Category = General)
		bool bUseHWsRGBEncoding;

	//Base Settings
	float PixelDensity;
	float DisplayRefreshRate;
	bool bApplyColorScaleAndOffsetToAllLayers;
	FLinearColor ColorScale;
	FLinearColor ColorOffset;

	virtual void PostInitProperties() override;

#if WITH_EDITOR
	virtual void PostEditChangeProperty(FPropertyChangedEvent& PropertyChangedEvent) override;
	void HandlesRGBHWSupport();
private:
	void ResetsRGBConfig();
#endif
};
