// Copyright 2020-2023 Mesiontech Technology Co., Ltd. All Rights Reserved.

#pragma once

#include "CoreMinimal.h"
#include "Modules/ModuleManager.h"
#include "IHeadMountedDisplayModule.h"

/**
 * The public interface to this module.  In most cases, this interface is only public to sibling modules 
 * within this plugin.
 */
class YYSSXRHMD_API IYyssXRHMDPlugin : public IHeadMountedDisplayModule
{

public:

	static inline IYyssXRHMDPlugin& Get()
	{
		return FModuleManager::LoadModuleChecked< IYyssXRHMDPlugin >("YyssXRHMD");
	}

	/**
	 * Checks to see if this module is loaded and ready.  It is only valid to call Get() if IsAvailable() returns true.
	 *
	 * @return True if the module is loaded and ready to use
	 */
	static inline bool IsAvailable()
	{
		return FModuleManager::Get().IsModuleLoaded("YyssXRHMD");
	}

	virtual bool IsExtensionAvailable(const FString& Name) const = 0;
	virtual bool IsExtensionEnabled(const FString& Name) const = 0;

	virtual bool IsLayerAvailable(const FString& Name) const = 0;
	virtual bool IsLayerEnabled(const FString& Name) const = 0;
};
