// Copyright 2020-2023 Mesiontech Technology Co., Ltd. All Rights Reserved.

#pragma once
#include "CoreMinimal.h"
#include "UObject/ObjectMacros.h"
#include "Kismet/BlueprintFunctionLibrary.h"
#include "HeadMountedDisplayBase.h"

#include "YyssXRFunctionLibrary.generated.h"

class FYyssXRHMD;

// UENUM(BlueprintType)
// enum class EYyssFixedFoveatedRenderingLevel : uint8
// {
// 	FFR_OFF = 0,
// 	FFR_LOW = 1,
// 	FFR_MEDIUM = 2,
// 	FFR_HIGH = 3,
// 	FFR_HIGHTOP = 4
// };

UENUM(BlueprintType)
enum class EPerformanceLevel : uint8
{
	LEVEL_POWER_SAVINGS = 0,
	LEVEL_SUSTAINED_LOW = 25,
	LEVEL_SUSTAINED_HIGH = 50,
	LEVEL_BOOST = 75,
	LEVEL_MAX = 100
};

UCLASS()
class YYSSXRHMD_API UYyssXRFunctionLibrary : public UBlueprintFunctionLibrary
{
	GENERATED_UCLASS_BODY()

	UFUNCTION(BlueprintPure, Category = "YyssLibrary")
	static void GetPose(FRotator& DeviceRotation, FVector& DevicePosition, FVector& NeckPosition, bool bUseOrienationForPlayerCamera = false, bool bUsePositionForPlayerCamera = false, const FVector PositionScale = FVector::ZeroVector);

	// UFUNCTION(BlueprintCallable, Category = "YyssLibrary")
	// static void SetCPUAndGPULevels(int CPULevel, int GPULevel);

	UFUNCTION(BlueprintPure, Category = "YyssLibrary")
	static bool HasInputFocus();

	UFUNCTION(BlueprintPure, Category = "YyssLibrary")
	static bool HasSystemOverlayPresent();

	// UFUNCTION(BlueprintPure, Category = "YyssLibrary")
	// static EYyssFixedFoveatedRenderingLevel GetFixedFoveatedRenderingLevel();

	// UFUNCTION(BlueprintCallable, Category = "YyssLibrary")
	// static void SetFixedFoveatedRenderingLevel(EYyssFixedFoveatedRenderingLevel level);

	UFUNCTION(BlueprintPure, Category = "YyssLibrary")
	static TArray<float> GetAvailableDisplayFrequencies();

	// UFUNCTION(BlueprintPure, Category = "YyssLibrary")
	// static float GetCurrentDisplayFrequency();

	// UFUNCTION(BlueprintCallable, Category = "YyssLibrary")
	// static void SetDisplayFrequency(float RequestedFrequency);

	// UFUNCTION(BlueprintCallable, Category = "YyssLibrary")
	// static void SetColorScaleAndOffset(FLinearColor ColorScale, FLinearColor ColorOffset, bool bApplyToAllLayers = false);

protected:
	static class FYyssXRHMD* GetYyssHMD();
};