// Copyright 2020-2023 Mesiontech Technology Co., Ltd. All Rights Reserved.

#pragma once

#include "CoreMinimal.h"
#include "HeadMountedDisplayBase.h"
#include "XRRenderBridge.h"
#include "XRSwapChain.h"
#include "YyssXRPlatformRHI.h"

#include "openxr.h"

class FYyssXRHMD;
class FRHICommandListImmediate;

class FYyssXRRenderBridge : public FXRRenderBridge
{
public:
	FYyssXRRenderBridge()
		: AdapterLuid(0)
		, OpenXRHMD(nullptr)
	{ }

	void SetOpenXRHMD(FYyssXRHMD* InHMD) { OpenXRHMD = InHMD; }
	virtual uint64 GetGraphicsAdapterLuid() { return AdapterLuid; }

	virtual void* GetGraphicsBinding() = 0;
	virtual FXRSwapChainPtr CreateSwapchain(XrSession InSession, uint8 Format, uint32 SizeX, uint32 SizeY, uint32 ArraySize, uint32 NumMips, uint32 NumSamples, ETextureCreateFlags Flags, ETextureCreateFlags TargetableTextureFlags, const FClearValueBinding& ClearValueBinding) = 0;

	FXRSwapChainPtr CreateSwapchain(XrSession InSession, FRHITexture2D* Template, ETextureCreateFlags Flags, ETextureCreateFlags TargetableTextureFlags)
	{
		if (!Template)
		{
			return nullptr;
		}

		return CreateSwapchain(InSession,
			Template->GetFormat(),
			Template->GetSizeX(),
			Template->GetSizeY(),
			1,
			Template->GetNumMips(),
			Template->GetNumSamples(),
			Template->GetFlags() | Flags,
			TargetableTextureFlags,
			Template->GetClearBinding());
	}

	/** FRHICustomPresent */
	virtual bool Present(int32& InOutSyncInterval) override;

protected:
	uint64 AdapterLuid;

private:
	FYyssXRHMD* OpenXRHMD;
};

#ifdef XR_USE_GRAPHICS_API_OPENGL_ES
FYyssXRRenderBridge* CreateRenderBridge_OpenGL(XrInstance InInstance, XrSystemId InSystem);
#endif
#ifdef XR_USE_GRAPHICS_API_VULKAN
FYyssXRRenderBridge* CreateRenderBridge_Vulkan(XrInstance InInstance, XrSystemId InSystem);
#endif
