﻿// Copyright 2020-2023 Mesiontech Technology Co., Ltd. All Rights Reserved.

#pragma once

#include "IMotionController.h"
#include "InputCoreTypes.h"
#include "GenericPlatform/GenericApplicationMessageHandler.h"

namespace YyssInput
{
	enum EYyssControllerButton : uint32_t
	{
		X,
		Y,
		LBack,
		LHome,
		LRocker,
		LTrigger,
		LGrip,
		LRockerUp,
		LRockerDown,
		LRockerLeft,
		LRockerRight,

		A,
		B,
		RBack,
		RHome,
		RRocker,
		RTrigger,
		RGrip,
		RRockerUp,
		RRockerDown,
		RRockerLeft,
		RRockerRight,
		
		Total
	};

	struct FYyssKey
	{
		static const FKey Yyss_Left_X_Click;
		static const FKey Yyss_Left_Y_Click;
		static const FKey Yyss_Left_Back_Click;
		static const FKey Yyss_Left_Home_Click;
		static const FKey Yyss_Left_Trigger_Click;
		static const FKey Yyss_Left_Grip_Click;
		static const FKey Yyss_Left_Rocker_Click;
		static const FKey Yyss_Left_Rocker_Up;
		static const FKey Yyss_Left_Rocker_Down;
		static const FKey Yyss_Left_Rocker_Left;
		static const FKey Yyss_Left_Rocker_Right;
		
		static const FKey Yyss_Right_A_Click;
		static const FKey Yyss_Right_B_Click;
		static const FKey Yyss_Right_Home_Click;
		static const FKey Yyss_Right_Back_Click;
		static const FKey Yyss_Right_Trigger_Click;
		static const FKey Yyss_Right_Grip_Click;
		static const FKey Yyss_Right_Rocker_Click;
		static const FKey Yyss_Right_Rocker_Up;
		static const FKey Yyss_Right_Rocker_Down;
		static const FKey Yyss_Right_Rocker_Left;
		static const FKey Yyss_Right_Rocker_Right;

		static const FKey Yyss_Left_X_Touch;
		static const FKey Yyss_Left_Y_Touch;
		static const FKey Yyss_Left_Trigger_Touch;
		static const FKey Yyss_Left_Rocker_Touch;

		static const FKey Yyss_Right_A_Touch;
		static const FKey Yyss_Right_B_Touch;
		static const FKey Yyss_Right_Trigger_Touch;
		static const FKey Yyss_Right_Rocker_Touch;

		static const FKey Yyss_Left_Trigger_Axis;
		static const FKey Yyss_Left_Grip_Axis;
		static const FKey Yyss_Left_Rocker_X;
		static const FKey Yyss_Left_Rocker_Y;

		static const FKey Yyss_Right_Trigger_Axis;
		static const FKey Yyss_Right_Grip_Axis;
		static const FKey Yyss_Right_Rocker_X;
		static const FKey Yyss_Right_Rocker_Y;
	};

	struct FYyssKeyNames
	{
		static const FName Yyss_Left_X_Click;
		static const FName Yyss_Left_Y_Click;
		static const FName Yyss_Left_Back_Click;
		static const FName Yyss_Left_Home_Click;
		static const FName Yyss_Left_Trigger_Click;
		static const FName Yyss_Left_Grip_Click;
		static const FName Yyss_Left_Rocker_Click;
		static const FName Yyss_Left_Rocker_Up;
		static const FName Yyss_Left_Rocker_Down;
		static const FName Yyss_Left_Rocker_Left;
		static const FName Yyss_Left_Rocker_Right;

		static const FName Yyss_Right_A_Click;
		static const FName Yyss_Right_B_Click;
		static const FName Yyss_Right_Back_Click;
		static const FName Yyss_Right_Home_Click;
		static const FName Yyss_Right_Trigger_Click;
		static const FName Yyss_Right_Grip_Click;
		static const FName Yyss_Right_Rocker_Click;
		static const FName Yyss_Right_Rocker_Up;
		static const FName Yyss_Right_Rocker_Down;
		static const FName Yyss_Right_Rocker_Left;
		static const FName Yyss_Right_Rocker_Right;

		static const FName Yyss_Left_X_Touch;
		static const FName Yyss_Left_Y_Touch;
		static const FName Yyss_Left_Trigger_Touch;
		static const FName Yyss_Left_Rocker_Touch;

		static const FName Yyss_Right_A_Touch;
		static const FName Yyss_Right_B_Touch;
		static const FName Yyss_Right_Trigger_Touch;
		static const FName Yyss_Right_Rocker_Touch;

		static const FName Yyss_Left_Trigger_Axis;
		static const FName Yyss_Left_Grip_Axis;
		static const FName Yyss_Left_Rocker_X;
		static const FName Yyss_Left_Rocker_Y;

		static const FName Yyss_Right_Trigger_Axis;
		static const FName Yyss_Right_Grip_Axis;
		static const FName Yyss_Right_Rocker_X;
		static const FName Yyss_Right_Rocker_Y;
	};

	struct FYyssButtonState
	{
		/** The Unreal button this maps to.  Different depending on whether this is the Left or Right hand controller */
		FName Key;

		/** Whether we're pressed or not.  While pressed, we will generate repeat presses on a timer */
		bool bIsPressed;

		/** Next time a repeat event should be generated for each button */
		double NextRepeatTime;

		/** Default constructor that just sets sensible defaults */
		FYyssButtonState()
			: Key(NAME_None),
			bIsPressed(false),
			NextRepeatTime(0.0)
		{
		}
	};


	struct FYyssControllerState
	{
		/** Button states */
		FYyssButtonState Buttons[EYyssControllerButton::Total];
		FYyssButtonState Touches[EYyssControllerButton::Total];

		float IndexTriggerAxis;
		float RockerAxis[2];

		float HapticAmplitude;
		float HapticFrequency;

		FYyssControllerState()
		{
			IndexTriggerAxis = 0.0;
			RockerAxis[0] = 0.0;
			RockerAxis[1] = 0.0;

			HapticAmplitude = 0.0;
			HapticFrequency = 0.0;

			for (FYyssButtonState& Button : Buttons)
			{
				Button.bIsPressed = false;
				Button.NextRepeatTime = 0.0;
			}

			Buttons[(int32)EYyssControllerButton::X].Key = FYyssKeyNames::Yyss_Left_X_Click;
			Buttons[(int32)EYyssControllerButton::Y].Key = FYyssKeyNames::Yyss_Left_Y_Click;
			Buttons[(int32)EYyssControllerButton::LBack].Key = FYyssKeyNames::Yyss_Left_Back_Click;
			Buttons[(int32)EYyssControllerButton::LHome].Key = FYyssKeyNames::Yyss_Left_Home_Click;
			Buttons[(int32)EYyssControllerButton::LTrigger].Key = FYyssKeyNames::Yyss_Left_Trigger_Click;
			Buttons[(int32)EYyssControllerButton::LGrip].Key = FYyssKeyNames::Yyss_Left_Grip_Click;
			Buttons[(int32)EYyssControllerButton::LRocker].Key = FYyssKeyNames::Yyss_Left_Rocker_Click;
			Buttons[(int32)EYyssControllerButton::LRockerUp].Key = FYyssKeyNames::Yyss_Left_Rocker_Up;
			Buttons[(int32)EYyssControllerButton::LRockerDown].Key = FYyssKeyNames::Yyss_Left_Rocker_Down;
			Buttons[(int32)EYyssControllerButton::LRockerLeft].Key = FYyssKeyNames::Yyss_Left_Rocker_Left;
			Buttons[(int32)EYyssControllerButton::LRockerRight].Key = FYyssKeyNames::Yyss_Left_Rocker_Right;

			Buttons[(int32)EYyssControllerButton::A].Key = FYyssKeyNames::Yyss_Right_A_Click;
			Buttons[(int32)EYyssControllerButton::B].Key = FYyssKeyNames::Yyss_Right_B_Click;
			Buttons[(int32)EYyssControllerButton::RBack].Key = FYyssKeyNames::Yyss_Right_Back_Click;
			Buttons[(int32)EYyssControllerButton::RHome].Key = FYyssKeyNames::Yyss_Right_Home_Click;
			Buttons[(int32)EYyssControllerButton::RTrigger].Key = FYyssKeyNames::Yyss_Right_Trigger_Click;
			Buttons[(int32)EYyssControllerButton::RGrip].Key = FYyssKeyNames::Yyss_Right_Grip_Click;
			Buttons[(int32)EYyssControllerButton::RRocker].Key = FYyssKeyNames::Yyss_Right_Rocker_Click;
			Buttons[(int32)EYyssControllerButton::RRockerUp].Key = FYyssKeyNames::Yyss_Right_Rocker_Up;
			Buttons[(int32)EYyssControllerButton::RRockerDown].Key = FYyssKeyNames::Yyss_Right_Rocker_Down;
			Buttons[(int32)EYyssControllerButton::RRockerLeft].Key = FYyssKeyNames::Yyss_Right_Rocker_Left;
			Buttons[(int32)EYyssControllerButton::RRockerRight].Key = FYyssKeyNames::Yyss_Right_Rocker_Right;


			for (FYyssButtonState& Touch : Touches)
			{
				Touch.bIsPressed = false;
				Touch.NextRepeatTime = 0.0;
			}

			Touches[(int32)EYyssControllerButton::X].Key = FYyssKeyNames::Yyss_Left_X_Touch;
			Touches[(int32)EYyssControllerButton::Y].Key = FYyssKeyNames::Yyss_Left_Y_Touch;
			Touches[(int32)EYyssControllerButton::LTrigger].Key = FYyssKeyNames::Yyss_Left_Trigger_Touch;
			Touches[(int32)EYyssControllerButton::LRocker].Key = FYyssKeyNames::Yyss_Left_Rocker_Touch;

			Touches[(int32)EYyssControllerButton::A].Key = FYyssKeyNames::Yyss_Right_A_Touch;
			Touches[(int32)EYyssControllerButton::B].Key = FYyssKeyNames::Yyss_Right_B_Touch;
			Touches[(int32)EYyssControllerButton::RTrigger].Key = FYyssKeyNames::Yyss_Right_Trigger_Touch;
			Touches[(int32)EYyssControllerButton::RRocker].Key = FYyssKeyNames::Yyss_Right_Rocker_Touch;
		}
	};
}